/*
	search routine generated by gen.
	skip=no, match=rev, shift=d12
*/
/*
 * The authors of this software are Andrew Hume and Daniel Sunday.
 * 
 * Copyright (c) 1991 by AT&T and Daniel Sunday.
 * 
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, provided that this entire notice
 * is included in all copies of any software which is or includes a copy
 * or modification of this software and in all copies of the supporting
 * documentation for such software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

#ifndef	CHARTYPE
#define	CHARTYPE	unsigned char
#endif
#define	MAXPAT	256

#ifndef	TABTYPE
#define	TABTYPE	long
#endif
typedef TABTYPE Tab;

static struct
{
	int patlen;
	CHARTYPE pat[MAXPAT];
	Tab delta1[256];
	Tab delta2[257];
        Tab delta[256];
        Tab dg[MAXPAT][128];
        int rarec, rareoff;
        int md2;

        long cmps, accs;
} pat;

void bmprep(CHARTYPE* base, int m)
{
	register Tab *d2;
	register int q1, t, qp, jp, kp, j;
	Tab f[256], f1[256];

	pat.patlen = m;
	if(m > MAXPAT)
		abort();
	memcpy(pat.pat, base, m);
	d2 = pat.delta1;
	for(j = 0; j < 256; j++)
		d2[j] = m;
	for(j = 0; j < m; j++)
		d2[base[j]] = m-1-j;
	d2 = pat.delta2;
	for(j = 1; j < m; j++)
		d2[j] = 2*m-j;
	for(j = m, t = m+1; j > 0; j--, t--){
		f[j] = t;
		while((t <= m) && (base[t-1] != base[j-1])){
			if((m-j) < d2[t])
				d2[t] = m-j;
			t = f[t];
		}
	}
	q1 = t;
	t = m+1-q1;
	qp = 1;
	for(jp = 1, kp = 0; kp < t; jp++, kp++){
		f1[jp] = kp;
		while((kp >= 1) && (base[jp-1] != base[kp-1]))
			kp = f1[kp];
	}
	while(q1 < m){
		for(j = qp; j <= q1; j++)
			if(m+q1-j < d2[j])
				d2[j] = m+q1-j;
		qp = q1+1;
		q1 += t-f1[t];
		t = f1[t];
	}

	d2[0] = m+1;		/* the case where the match succeeded */
}

CHARTYPE* bmexec_cnt(CHARTYPE* base, int n)
{
	register CHARTYPE *e, *s;
	register int s_offset;
	register CHARTYPE *p, *q;
	register int n1 = pat.patlen-1;
	register CHARTYPE *ep;
	register Tab *d1 = pat.delta1;
	register Tab *d2 = pat.delta2+1;
	register int k1, k2;

	s = base+pat.patlen-1;
	e = base+n;
	s_offset = 1-pat.patlen;
	ep = pat.pat; pat.cmps = pat.accs = 0;
	while(s < e){
		for(p = pat.pat+n1, q = s+n1+s_offset; p >= ep; ){
			if(++pat.cmps,(*q-- != *p--)){
				q++, p++;
				goto mismatch;
			}
		}
		if(p < ep) return q+1; else return q;
	mismatch:
		k2 = d2[p-pat.pat];
		k1 = d1[*q]; ++pat.accs;
		if(k2 < k1)
			k2 = k1;
		k2 = q+k2-s+n1+s_offset;
		s += k2;
	}
	return e;
}

CHARTYPE* bmexec(CHARTYPE* base, int n)
{
	register CHARTYPE *e, *s;
	register int s_offset;
	register CHARTYPE *p, *q;
	register int n1 = pat.patlen-1;
	register CHARTYPE *ep;
	register Tab *d1 = pat.delta1;
	register Tab *d2 = pat.delta2+1;
	register int k1, k2;

	s = base+pat.patlen-1;
	e = base+n;
	s_offset = 1-pat.patlen;
	ep = pat.pat;
	while(s < e){
		for(p = pat.pat+n1, q = s+n1+s_offset; p >= ep; ){
			if(*q-- != *p--){
				q++, p++;
				goto mismatch;
			}
		}
		if(p < ep) return q+1; else return q;
	mismatch:
		k2 = d2[p-pat.pat];
		k1 = d1[*q];
		if(k2 < k1)
			k2 = k1;
		k2 = q+k2-s+n1+s_offset;
		s += k2;
	}
	return(e);
}

CHARTYPE* slowbm(CHARTYPE* text, CHARTYPE* textEnd, CHARTYPE* pat, CHARTYPE* patEnd) 
{
  bmprep(pat, patEnd - pat);  
  return bmexec(text, textEnd - text);
}

template <class RandomAccessIterator1, class RandomAccessIterator2>
RandomAccessIterator1 slowbm(
                    RandomAccessIterator1 txt, RandomAccessIterator1 txtEnd,
                    RandomAccessIterator2 pt, RandomAccessIterator2 ptEnd)
{
#ifdef __GNUC__
  CHARTYPE* pat = (CHARTYPE*)pt;
  CHARTYPE* text = (CHARTYPE*)txt;
#else
  CHARTYPE* pat = (CHARTYPE*)pt.base();
  CHARTYPE* text = (CHARTYPE*)txt.base();
#endif
  bmprep(pat, ptEnd - pt);
  CHARTYPE* result = bmexec_cnt(text, txtEnd - txt);
  data::accesses = ::pat.accs;
  data::equal_comparisons = ::pat.cmps;
#ifdef __GNUC__
  return (RandomAccessIterator1)result;
#else
  return (RandomAccessIterator1)(data*)result;
#endif
}

#include "freq.h"

void humprep(const CHARTYPE* base, int m)
{
  	CHARTYPE *skipc;
	register CHARTYPE *pe, *p;
	register int j;
	register Tab *d;
	int rrr, rr;
	register CHARTYPE *pmd2;

	pat.patlen = m;
	if(m > MAXPAT)
		abort();
	memcpy(pat.pat, base, m);
	skipc = 0;
	d = pat.delta;
	for(j = 0; j < 256; j++)
		d[j] = pat.patlen;
	for(p = pat.pat, pe = p+m-1; p < pe; p++)
		d[*p] = pe-p;
	d[*p] = 0;
	skipc = (CHARTYPE *)p;
	rrr = 0;
	for(rr = 1; rr < m; rr++){
		if(freq[pat.pat[rr]] < freq[pat.pat[rrr]])
			rrr = rr;
	}
	pat.rarec = pat.pat[rrr];
       	pat.rareoff = rrr - (m-1);
	for(pmd2 = skipc-1; pmd2 >= pat.pat; pmd2--)
		if (*pmd2 == *skipc) break;
	pat.md2 = skipc - pmd2;	/* *pmd2 is first leftward reoccurance of *pe */
}

const CHARTYPE* humexec(const CHARTYPE* base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;
	register const CHARTYPE *p, *q;
	register const CHARTYPE *ep;
	register int ro, rc;
	register int n1 = pat.patlen-1;
	register int md2 = pat.md2;

	s = base+pat.patlen-1;
	e = base+n;
	ro = pat.rareoff;
	rc = pat.rarec;

	ep = pat.pat + pat.patlen-1;
	while(s < e){
	        int k = 0;
	        while( (k = d0[*(s += k)]) != 0 && (s < e));
		if(s >= e)
			break;
		if(s[ro] != rc)
			goto mismatch;

		for(p = pat.pat, q = s-n1; p < ep; ){
			if(*q++ != *p++)
				goto mismatch;
		}
		return s - n1;
	mismatch:
		s += md2;
	}
	return e;
}
const CHARTYPE* humexec_cnt(const CHARTYPE* base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;
	register int ro, rc;

	register const CHARTYPE *p, *q;
	register const CHARTYPE *ep;
	register int n1 = pat.patlen-1;
	register int md2 = pat.md2;

	s = base+pat.patlen-1;
	e = base+n;

	ro = pat.rareoff;
	rc = pat.rarec;

	ep = pat.pat + pat.patlen-1; pat.cmps = pat.accs = 0;
	while(s < e){
	        int k = 0;
	        while( (++pat.accs,(k = d0[*(s += k)])) != 0 && (s < e));
		if(s >= e)
			break;
		if(++pat.cmps,(s[ro] != rc))
			goto mismatch;
		for(p = pat.pat, q = s-n1; p < ep; ){
			if(++pat.cmps,(*q++ != *p++))
				goto mismatch;
		}
		return s - n1;
	mismatch:
		s += md2;
	}
	return e;
}

const CHARTYPE* hume(const CHARTYPE* text, const CHARTYPE* textEnd, const CHARTYPE* pat, const CHARTYPE* patEnd) 
{
  humprep(pat, patEnd - pat);  
  return humexec(text, textEnd - text);
}

/*

template <class RandomAccessIterator1, class RandomAccessIterator2>
RandomAccessIterator1 hume(
                    RandomAccessIterator1 txt, RandomAccessIterator1 txtEnd,
                    RandomAccessIterator2 pt, RandomAccessIterator2 ptEnd)
{
#ifdef __GNUC__
  CHARTYPE* pat = (CHARTYPE*)pt;
  CHARTYPE* text = (CHARTYPE*)txt;
#else
  CHARTYPE* pat = (CHARTYPE*)pt.base();
  CHARTYPE* text = (CHARTYPE*)txt.base();
#endif
  humprep(pat, ptEnd - pt);
  CHARTYPE* result = humexec_cnt(text, txtEnd - txt);
  data::accesses = ::pat.accs;
  data::equal_comparisons = ::pat.cmps;
#ifdef __GNUC__
  return (RandomAccessIterator1)result;
#else
  return (RandomAccessIterator1)(data*)result;
#endif
}

*/

void fbmprep(const CHARTYPE *base, int m)
{
	register const CHARTYPE *pe, *p;
	register int j;
	register Tab *d;
	register Tab *d2;
	register int q1, t, qp, jp, kp;
	Tab f[256], f1[256];

	pat.patlen = m;
	if(m > MAXPAT)
		abort();
	memcpy(pat.pat, base, m);

	d = pat.delta;
	for(j = 0; j < 256; j++)
		d[j] = pat.patlen;
	for(p = pat.pat, pe = p+m-1; p < pe; p++)
		d[*p] = pe-p;
	d[*p] = 0;

	d2 = pat.delta1;
	for(j = 0; j < 256; j++)
		d2[j] = m;
	for(j = 0; j < m; j++)
		d2[base[j]] = m-1-j;
	d2 = pat.delta2;
	for(j = 1; j < m; j++)
		d2[j] = 2*m-j;
	for(j = m, t = m+1; j > 0; j--, t--){
		f[j] = t;
		while((t <= m) && (base[t-1] != base[j-1])){
			if((m-j) < d2[t])
				d2[t] = m-j;
			t = f[t];
		}
	}
	q1 = t;
	t = m+1-q1;
	qp = 1;
	for(jp = 1, kp = 0; kp < t; jp++, kp++){
		f1[jp] = kp;
		while((kp >= 1) && (base[jp-1] != base[kp-1]))
			kp = f1[kp];
	}
	while(q1 < m){
		for(j = qp; j <= q1; j++)
			if(m+q1-j < d2[j])
				d2[j] = m+q1-j;
		qp = q1+1;
		q1 += t-f1[t];
		t = f1[t];
	}
	d2[0] = m+1;		/* the case where the match succeeded */
}

const CHARTYPE* fbmexec(const CHARTYPE *base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;

	register const CHARTYPE *p, *q;
	register const CHARTYPE *prev = pat.pat+pat.patlen-1;
	register Tab *d2 = pat.delta2+1;
	register int k1;

	s = base+pat.patlen-1;
	e = base+n;

	while(s < e){
	        int k = 0;
	        while( (k = d0[*(s += k)]) != 0 && (s < e));
		if(s >= e)
			break;
		for(p = prev, q = s; p > pat.pat; ){
			if(*--q != *--p)
				goto mismatch;
		}
		return q;
	mismatch:
		k = d2[p-pat.pat];
		k1 = d0[*q];
		if(k < k1)
			k = k1;
		s = q+k;
	}
	return e;
}

const CHARTYPE* fbmexec_cnt(const CHARTYPE *base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;

	register const CHARTYPE *p, *q;
	register const CHARTYPE *prev = pat.pat+pat.patlen-1;
	register Tab *d2 = pat.delta2+1;
	register int k1;

	s = base+pat.patlen-1;
	e = base+n; pat.cmps = pat.accs = 0;
	while(s < e){
	        int k = 0;
	        while( (++pat.accs,(k = d0[*(s += k)])) != 0 && (s < e));
		if(s >= e)
			break;
		for(p = prev, q = s; p > pat.pat; ){
			if(++pat.cmps,(*--q != *--p))
				goto mismatch;
		}
		return q;
	mismatch:
		k = d2[p-pat.pat];
		k1 = d0[*q];++pat.accs;
		if(k < k1)
			k = k1;
		s = q+k;
	}
	return e;
}

const CHARTYPE* fbm(const CHARTYPE* text, const CHARTYPE* textEnd, const CHARTYPE* pat, const CHARTYPE* patEnd) 
{
  fbmprep(pat, patEnd - pat);  
  return fbmexec(text, textEnd - text);
}

/*
template <class RandomAccessIterator1, class RandomAccessIterator2>
RandomAccessIterator1 fbm(
                    RandomAccessIterator1 txt, RandomAccessIterator1 txtEnd,
                    RandomAccessIterator2 pt, RandomAccessIterator2 ptEnd)
{
#ifdef __GNUC__
  CHARTYPE* pat = (CHARTYPE*)pt;
  CHARTYPE* text = (CHARTYPE*)txt;
#else
  const CHARTYPE* pat = (const CHARTYPE*)pt.base();
  const CHARTYPE* text = (const CHARTYPE*)txt.base();
#endif
  fbmprep(pat, ptEnd - pt);
  CHARTYPE* result = fbmexec_cnt(text, txtEnd - txt);
  data::accesses = ::pat.accs;
  data::equal_comparisons = ::pat.cmps;
#ifdef __GNUC__
  return (RandomAccessIterator1)result;
#else
  return (RandomAccessIterator1)(data*)result;
#endif
}
*/

void gdprep(const CHARTYPE *base, int m)
{
	register const CHARTYPE *pe, *p;
	register int j;
	register Tab *d;
	register int j0, k, q, i, jj;
	int endof[MAXPAT], rmin[MAXPAT];

	pat.patlen = m;
	if(m > MAXPAT)
		abort();
	memcpy(pat.pat, base, m);
	d = pat.delta;
	for(j = 0; j < 256; j++)
		d[j] = pat.patlen;
	for(p = pat.pat, pe = p+m-1; p < pe; p++)
		d[*p] = pe-p;
	d[*p] = 0;
	/*
		endof[k] is the maximal integer such that k is not a period
		rmin[jj] is the minimal period of p[0,m-1] > jj
		rmin[0] is the period of pat
	*/

	for(i=0; i<m; i++)
		rmin[i] = m;
	for(k = 1, i = k, jj = 0; k < m; ){
		while((pat.pat[i] == pat.pat[i-k]) && (i < m))
			i++;
		endof[k] = i;
		q = k+1;
		if(i == m){
			for(j0 = jj; j0 < k; j0++)
				rmin[j0] = k;  
			jj = k;
		}
		while(endof[q-k]+k < i){ 
       			endof[q] = endof[q-k]+k;
       			q = q+1;
		}
		k = q;
		if(k == i+1)
			i = k;
	}

	/* compute pat.dg[jj,a] */
	for(jj = 0; jj < m; jj++){ 
		for(i = 0; i < 128; i++)
			pat.dg[jj][i] = m-1-jj+rmin[jj];
	}
	for(k = m-2; k >= 0; k--){
		for(i = k, jj = m-1; pat.pat[i] == pat.pat[jj]; i--, jj--)
			;
		if((i >= 0) && (pat.dg[jj][pat.pat[i]]>=m))
			pat.dg[jj][pat.pat[i]] = m-1-i;
	}
}

const CHARTYPE* gdexec(const CHARTYPE *base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;

	register const CHARTYPE *p, *q;
	register const CHARTYPE *prev = pat.pat+pat.patlen-1;
	register int kg;

	s = base+pat.patlen-1;
	e = base+n;
	while(s < e){
	        int k = 0;
	        while( (k = d0[*(s += k)]) != 0 && (s < e));
		if(s >= e)
			break;
		for(p = prev, q = s; p > pat.pat; ){
			if(*--q != *--p)
				goto mismatch;
		}
		return q;
	mismatch:
		if(p < pat.pat)
			kg = pat.patlen+1;
		else
			kg = pat.dg[p-pat.pat][*q];
		s = q+kg;
	}
	return e;
}

const CHARTYPE* gdexec_cnt(const CHARTYPE *base, int n)
{
	register const CHARTYPE *e, *s;
	register Tab *d0 = pat.delta;

	register const CHARTYPE *p, *q;
	register const CHARTYPE *prev = pat.pat+pat.patlen-1;
	register int kg;

	s = base+pat.patlen-1;
	e = base+n; pat.accs = pat.cmps = 0;
	while(s < e){
	        int k = 0;
	        while( (++pat.accs,(k = d0[*(s += k)])) != 0 && (s < e));
		if(s >= e)
			break;
		for(p = prev, q = s; p > pat.pat; ){
			if(++pat.cmps,(*--q != *--p))
				goto mismatch;
		}
		return q;
	mismatch:
		if(p < pat.pat)
			kg = pat.patlen+1;
		else
		  {kg = pat.dg[p-pat.pat][*q]; ++pat.accs;}
		s = q+kg;
	}
	return e;
}

const CHARTYPE* gdbm(const CHARTYPE* text, const CHARTYPE* textEnd, 
                     const CHARTYPE* pat, const CHARTYPE* patEnd) 
{
  gdprep(pat, patEnd - pat);  
  return gdexec(text, textEnd - text);
}

/*

template <class RandomAccessIterator1, class RandomAccessIterator2>
RandomAccessIterator1 gdbm(
                    RandomAccessIterator1 txt, RandomAccessIterator1 txtEnd,
                    RandomAccessIterator2 pt, RandomAccessIterator2 ptEnd)
{
#ifdef __GNUC__
  CHARTYPE* pat = (CHARTYPE*)pt;
  CHARTYPE* text = (CHARTYPE*)txt;
#else
  CHARTYPE* pat = (CHARTYPE*)pt.base();
  CHARTYPE* text = (CHARTYPE*)txt.base();
#endif
  gdprep(pat, ptEnd - pt);
  CHARTYPE* result = gdexec_cnt(text, txtEnd - txt);
  data::accesses = ::pat.accs;
  data::equal_comparisons = ::pat.cmps;
#ifdef __GNUC__
  return (RandomAccessIterator1)result;
#else
  return (RandomAccessIterator1)(data*)result;
#endif
}

*/
