// ======================================================================
// PROVIDED CODE - DO NOT EDIT THIS FILE
// ======================================================================

#ifndef _DIFF_H_
#define _DIFF_H_

#include <cstdlib>
#include <string>
#include <cassert>


//
// The EDIT enum type
//
enum EDIT { INSERT, ERASE, REPLACE };


//
// A helper function that converts a string token from a Diff file
// into the EDIT enum type.
//
EDIT edit_type(const std::string &type);


//
// The Diff class stores a single edit operation of type insert,
// erase, or replace.  It stores the integer position from the
// original file at which to perform this edit.  It also stores the
// insert or replacement value.
//
class Diff {
public:
  // CONSTRUCTOR
  Diff(int p, EDIT t, std::string v="") : position(p), type(t), value(v) {}
  // ACCESSORS
  int getPosition() const { return position; }
  EDIT getType() const { return type; }
  const std::string& getValue() const { return value; }
private:
  // PRIVATE REPRESENTATION
  int position;
  EDIT type;
  std::string value;
};

#endif
