// ======================================================================
// PROVIDED CODE - DO NOT EDIT THIS FILE
// ======================================================================

#include <cstdlib>
#include <cassert>
#include <iostream>
#include <string>
#include <list>

#include "diff.h"
#include "input_output.h"
#include "render.h"
#include "solution.h"


int main() {

  // helper variables to read in each command
  std::string command;
  std::string type;
  std::string filename1,filename2,filename3;

  // Interactive Command Loop
  // (likely re-directed from a file on the command line)
  while (std::cin >> command) {

    // 
    // The compute_diff command takes in two input text files and
    // determines a set of edits (insert, erase, and replace) that
    // will transform the first input file into the second input file.
    //
    // This problem often has many valid answers.  Finding the optimal
    // or minimum set of edits is called the "Minimum Edit Distance"
    // and is a known difficult and expensive problem.  Students are
    // NOT EXPECTED to implement an efficient algorithm that is
    // guaranteed to find the optimal/best/minimal answer for all
    // cases.  Students should focus on an efficient algorithm that
    // finds a good answer when the input does not have
    // adjacent/neighboring elements that require edits.
    //
    // The diff file is saved to the third filename.
    //
    if (command.substr(0,12) == std::string("compute_diff")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2 >> filename3;
      std::cout << "Compute diff between '" << filename1 << "' & '" << filename2 << "'";
      std::list<std::string> a = read_text(p_type,filename1);
      std::list<std::string> b = read_text(p_type,filename2);
      //
      // NOTE: The compute_diff command is actually a family of
      // commands that you may explore for extra credit.
      //
      // If the command token is "compute_diff" you should perform a
      // simple and efficient difference detection scheme that works
      // for inputs that do not require edits to adjacent/neighboring
      // chars/words/lines.
      //
      // For extra credit, you can implement "compute_diff_recursive"
      // which will use recursion to find the optimal/shortest minimum
      // edit distance difference file.  And you may implement other
      // variants of the algorithm with other command strings as
      // desired.
      //
      std::list<Diff> diff = compute_diff(command,a,b);
      std::cout << ", score=" << diff.size() << ", save to '" << filename3 << "'" << std::endl;
      write_diff(p_type,diff,filename3);
    }

    // 
    // The apply_diff command takes in an input text file and a diff
    // file and applies each operation from the diff file to the input
    // file.
    //
    // The resultant text file is saved to the third filename.
    //
    else if (command == std::string("apply_diff")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2 >> filename3;
      std::cout << "Apply to '" << filename1 << "' diff '" << filename2 << "'";
      std::list<std::string> a = read_text(p_type,filename1);
      std::list<Diff> diff = read_diff(p_type,filename2);
      std::list<std::string> b = a;
      apply_diff(b,diff);
      std::cout << ", save to '" << filename3 << "'" << std::endl;
      write_text(p_type,b,filename3);
    }

    // 
    // The invert_diff command takes in an input text file, e.g., A,
    // and a diff file, e.g., to transform A to B, and constructs and
    // outputs a new diff file that will transform B back to A.  This
    // function inverts each insert, erase, or replace operation.
    //
    // This diff file can be used for debugging, and it is also used
    // to create the HTML diff visualization.
    //
    // NOTE: This function should not call compute_diff.
    //
    // The resultant diff file is saved to the third filename.
    //
    else if (command == std::string("invert_diff")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2 >> filename3;
      std::cout << "For input '" << filename1 << "' invert diff '" << filename2 << "'";
      std::list<std::string> a = read_text(p_type,filename1);
      std::list<Diff> diff = read_diff(p_type,filename2);
      std::list<Diff> inverted = invert_diff(a,diff);
      std::cout << ", save to '" << filename3 << "'" << std::endl;
      write_diff(p_type,inverted,filename3);
    }

    //
    // The render_diff operation is implmented in the render.h and
    // render.cpp files.
    // 
    else if (command == std::string("render_diff")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2 >> filename3;
      std::cout << "For input '" << filename1 << "' render diff '" << filename2 << "'";
      std::list<std::string> a = read_text(p_type,filename1);
      std::list<Diff> diff = read_diff(p_type,filename2);
      std::cout << ", save to '" << filename3 << "'" << std::endl;      
      render_diff(p_type,a,diff,filename3);
    }

    //
    // The assert_same operation is a debugging command.  It succeeds
    // when the two text files are identical.
    //
    // On failure (when the files are different), this command prints
    // to cerr and exits the program with error code = 1.
    //
    else if (command == std::string("assert_same")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2;
      std::list<std::string> a = read_text(p_type,filename1);
      std::list<std::string> b = read_text(p_type,filename2);
      bool same = assert_same(a,b);
      if (same) {
        std::cout << "Files '" << filename1 << "' and '" << filename2 << "' are the same." << std::endl;
      } else {
        std::cerr << "ERROR: Files '" << filename1 << "' and '" << filename2 << "' are not the same." << std::endl;
        exit(1);
      }
    }

    //
    // The assert_same_diff operation is a debugging command.  It
    // succeeds when the two diff files are identical.
    //
    // On failure (when the files are different), this command prints
    // to cerr and exits the program with error code = 1.
    //
    else if (command == std::string("assert_same_diff")) {
      std::cin >> type;
      PARSE p_type = parse_type(type);
      std::cin >> filename1 >> filename2;
      std::list<Diff> a = read_diff(p_type,filename1);
      std::list<Diff> b = read_diff(p_type,filename2);
      bool same = assert_same_diff(a,b);
      if (same) {
        std::cout << "Diff files '" << filename1 << "' and '" << filename2 << "' are the same." << std::endl;
      } else {
        std::cerr << "ERROR: Diff files '" << filename1 << "' and '" << filename2 << "' are not the same." << std::endl;
        exit(1);
      }
    }

    else {
      std::cout << "ERROR: Unknown Command '" << command << "'" << std::endl;
      exit(1);
    }
  }
}

