// ======================================================================
// PROVIDED CODE - DO NOT EDIT THIS FILE
// ======================================================================

#include <iostream>
#include <fstream>
#include "diff.h"
#include "input_output.h"
#include "solution.h"
#include "render.h"


//
// This helper function escapes a few special characters so they
// display correctly (are not confused as being part of HTML
// formatting).
//
// This function is likely incomplete.  Students may edit this
// function to add additional escaped characters if desired to handle
// their additional testing.
//
void html_encode(std::ostream &ostr, const std::string &s) {
  for (std::string::const_iterator s_itr = s.begin(); s_itr != s.end(); s_itr++) {
    if (*s_itr == ' ') ostr << "&nbsp;";
    else if (*s_itr == '<') ostr << "&lt;";
    else if (*s_itr == '>') ostr << "&gt;";
    else if (*s_itr == '\n') ostr << "<br>";
    else ostr << *s_itr;
  }
}


//
// This helper function renders one of the two inputs.  (The boolean
// indicates whether it is the first or second input, which will flip
// the colors.)
//
//
void render_diff(PARSE type, std::ostream &ostr,
                 const std::list<std::string> &input, const std::list<Diff> &diff,
                 bool invert) {

  // which color should be used for the highlights
  std::string color = "red";
  if (invert) color = "green";

  // the text is by default white
  ostr<<"<white>"; 

  // iterate through the input and diference file simultaneously
  int i = 0;
  std::list<std::string>::const_iterator itr = input.begin();
  std::list<Diff>::const_iterator d_itr = diff.begin();
  
  while (itr != input.end() || d_itr != diff.end()) {

    // with an insert operation, insert the indicated number of
    // placeholder characters with a medium grey background color
    if (d_itr != diff.end() && d_itr->getPosition() == i && d_itr->getType() == EDIT::INSERT) {
      int c = d_itr->getValue().size();
      ostr<<"<grey>";
      for (int i = 0; i < c; i++) { ostr << "&nbsp;"; }
      ostr << "</grey>";
      d_itr++;
    }

    // with an erase operation, highlight the text with the appropriate color
    else if (d_itr != diff.end() && d_itr->getPosition() == i && d_itr->getType() == EDIT::ERASE) {
      ostr << "<" << color << ">"; 
      html_encode(ostr,*itr);
      ostr << "</" << color << ">"; 
      i++;
      itr++;
      d_itr++;
    }

    // with an erase operation, both highlight the text with an
    // appropriate color AND insert the extra spaces if the
    // replacement text is longer
    else if (d_itr != diff.end() && d_itr->getPosition() == i && d_itr->getType() == EDIT::REPLACE) {
      ostr << "<" << color << ">"; 
      html_encode(ostr,*itr);
      ostr << "</" << color << ">"; 
      int c = d_itr->getValue().size() - itr->size();
      if (c > 0) {
        ostr<<"<grey>";
        for (int i = 0; i < c; i++) { ostr << "&nbsp;"; }
        ostr << "</grey>";
      }
      i++;
      itr++;
      d_itr++;
    }

    // otherwise, display the text with a white background
    else {
      html_encode(ostr,*itr);
      i++;
      itr++;
    }

    // in WORD mode, put spaces between the words, which allows them to wrap
    if (type == PARSE::WORD) {
      ostr << " ";
    }

    // and in LINE mode, add line breaks
    else if (type == PARSE::LINE) {
      ostr << "<br>";
    }
  }

  ostr<<"</white>\n"; 
}


//
// This function is given the contents of one input text file, and a
// difference file that contains specific edits that can be performed
// to transform this file into the second input.
//
// This function saves an HTML visualization of this difference using
// pink and green highlights.  This HTML visualization can be loaded
// in any modern web browser (Chrome, Firefox, Safari, Edge).
//
void render_diff(PARSE type,
                 const std::list<std::string> &input, const std::list<Diff> &diff,
                 const std::string &filename) {

  std::ofstream ostr(filename);
  if (!ostr.good()) {
    std::cout << "ERROR: Could not open output file: '" << filename << "'" << std::endl;
    exit(1);
  }
                  
  // reconstruct the second file from the first, and invert the differences
  std::list<std::string> second_input = input;
  apply_diff(second_input,diff);
  std::list<Diff> inverted = invert_diff(input,diff);

  // header information for the HTML visualization defining colors & styles
  ostr << "<html><head><style>"
       << "red { background-color: #ff8888; color: black;}" 
       << "green { background-color: #88ff88; color: black;}"
       << "grey { background-color: #bbbbbb; color: black;}"
       << "white { background-color: #ffffff; color: black;}"
       << "div { float: left; background-color: #eeeeee; border: 2px solid black; padding: 10px; margin: 2px; }"
       << "</style></head>"
       << "<body style=\"background-color:#ffffff\">"
       << "<tt>"
       << std::endl;

  // render the input file
  ostr << "<div>\n";
  render_diff(type,ostr,input,diff,false);
  ostr << "</div>\n";

  // render the second input file
  ostr << "<div>\n";
  render_diff(type,ostr,second_input,inverted,true);
  ostr << "</div>\n";

  // footer information
  ostr << "</tt></body></html>" << std::endl;
}
