#ifndef __ARG_PARSER_H__
#define __ARG_PARSER_H__

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <cassert>

class ArgParser {

public:

  ArgParser() { DefaultValues(); }

  ArgParser(int argc, char *argv[]) {
    DefaultValues();

    for (int i = 1; i < argc; i++) {
      if (!strcmp(argv[i],"-input")) {
	i++; assert (i < argc); 
	input_file = argv[i];
      } else if (!strcmp(argv[i],"-points")) {
	i++; assert (i < argc); 
	points = atoi(argv[i]);
      } else if (!strcmp(argv[i],"-iters")) {
	i++; assert (i < argc); 
	iters = atoi(argv[i]);
      } else if (!strcmp(argv[i],"-size")) {
	i++; assert (i < argc); 
	width = height = atoi(argv[i]);
      } else if (!strcmp(argv[i],"-cubes")) {
        cubes = true;
      } else {
	printf ("whoops error with command line argument %d: '%s'\n",i,argv[i]);
	assert(0);
      }
    }
  }

  void DefaultValues() {
    input_file = NULL;
    points = 10000;
    iters = 3;
    width = 100;
    height = 100;
    output_file = NULL;
    color = NULL;
    cubes = 0;
  }

  // ==============
  // REPRESENTATION
  // all public! (no accessors)

  char *input_file;
  int points;
  int iters;
  int width;
  int height;
  char *output_file;
  char *color;
  int cubes;
};

#endif
