#ifndef _CAMERA_H_
#define _CAMERA_H_

#include <assert.h>
#include <limits.h>
#include "vectors.h"

// ====================================================================

class Camera {

public:
  // CONSTRUCTOR & DESTRUCTOR
  Camera(Vec3f c, Vec3f d, Vec3f u);
  virtual ~Camera() {}

  // GL NAVIGATION
  virtual void glInit(int w, int h) = 0;
  void glPlaceCamera(void);
  virtual void zoomCamera(float dist) = 0;
  virtual void truckCamera(float dx, float dy) = 0;
  virtual void rotateCamera(float rx, float ry) = 0;
  virtual void Print() = 0;

protected:
  Camera() { assert(0); } // don't use

  // HELPER FUNCTIONS
  const Vec3f getHorizontal() const {
    Vec3f answer;
    Vec3f::Cross3(answer, direction, up);
    answer.Normalize();
    return answer; }
  const Vec3f getScreenUp() const {
    Vec3f answer;
    Vec3f::Cross3(answer, getHorizontal(), direction);
    return answer; }

  // REPRESENTATION
  Vec3f center;
  Vec3f direction;
  Vec3f up;
};

// ====================================================================

class OrthographicCamera : public Camera {

public:
  // CONSTRUCTOR & DESTRUCTOR
  OrthographicCamera(Vec3f c, Vec3f d, Vec3f u, float s);
 ~OrthographicCamera(void) { }

  // GL NAVIGATION
  void glInit(int w, int h);
  void zoomCamera(float factor);
  void truckCamera(float dx, float dy);
  void rotateCamera(float rx, float ry);
  void Print() {
    printf ("OrthographicCamera {\n");
    printf ("    center    ");
    cout << center;
    printf ("    direction ");
    cout << direction;
    printf ("    up        ");
    cout << up; 
    printf ("    size      %f\n", size);
    printf ("}\n");
  }    

private:
  OrthographicCamera() { assert(0); } // don't use

  // REPRESENTATION
  float size;
  Vec3f lowerLeft;
  Vec3f xAxis;
  Vec3f yAxis;
};

// ====================================================================

#endif
