#include "argparser.h"
#include "ifs.h"
#include "glCanvas.h"

// Included files for OpenGL Rendering
#ifdef __APPLE__
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#endif

// ====================================================================
// ====================================================================

int main(int argc, char *argv[]) {
  ArgParser *args = new ArgParser(argc, argv);
  IFS *ifs = new IFS();
  GLCanvas glcanvas;

  glutInit(&argc,argv);
  glcanvas.initialize(args,ifs); 

  delete ifs;
  delete args;
  return 0;
}

// ====================================================================
// ====================================================================

