#include "boundingbox.h"

// Included files for OpenGL Rendering
#ifdef __APPLE__
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#endif

// ====================================================================
// ====================================================================

void BoundingBox::paint() const {
  // draw a wireframe box to represent the boundingbox
  
  glColor3f(1,1,1);
  glLineWidth(1);
  glDisable(GL_LIGHTING);
  glBegin(GL_LINES);

  glVertex3f(minimum.x(),minimum.y(),minimum.z());
  glVertex3f(maximum.x(),minimum.y(),minimum.z());
  glVertex3f(minimum.x(),minimum.y(),minimum.z());
  glVertex3f(minimum.x(),maximum.y(),minimum.z());
  glVertex3f(maximum.x(),maximum.y(),minimum.z());
  glVertex3f(maximum.x(),minimum.y(),minimum.z());
  glVertex3f(maximum.x(),maximum.y(),minimum.z());
  glVertex3f(minimum.x(),maximum.y(),minimum.z());

  glVertex3f(minimum.x(),minimum.y(),minimum.z());
  glVertex3f(minimum.x(),minimum.y(),maximum.z());
  glVertex3f(minimum.x(),maximum.y(),minimum.z());
  glVertex3f(minimum.x(),maximum.y(),maximum.z());
  glVertex3f(maximum.x(),minimum.y(),minimum.z());
  glVertex3f(maximum.x(),minimum.y(),maximum.z());
  glVertex3f(maximum.x(),maximum.y(),minimum.z());
  glVertex3f(maximum.x(),maximum.y(),maximum.z());

  glVertex3f(minimum.x(),minimum.y(),maximum.z());
  glVertex3f(maximum.x(),minimum.y(),maximum.z());
  glVertex3f(minimum.x(),minimum.y(),maximum.z());
  glVertex3f(minimum.x(),maximum.y(),maximum.z());
  glVertex3f(maximum.x(),maximum.y(),maximum.z());
  glVertex3f(maximum.x(),minimum.y(),maximum.z());
  glVertex3f(maximum.x(),maximum.y(),maximum.z());
  glVertex3f(minimum.x(),maximum.y(),maximum.z());

  glEnd();
  glEnable(GL_LIGHTING);	   
}

// ====================================================================
// ====================================================================
