#include <iostream> 
#include <ctime> 
#include <cstdlib>

#include "argparser.h"
#include "glCanvas.h"
#include "mesh.h"

// Included files for OpenGL Rendering
#ifdef __APPLE__
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <GLUT/glut.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#endif

// =========================================
// =========================================

int main(int argc, char *argv[]) {
  // deterministic (repeatable) randomness
  srand(37);  
  // "real" randomness
  //srand((unsigned)time(0));

  ArgParser *args = new ArgParser(argc, argv);
  Mesh *mesh = new Mesh();
  mesh->Load(args->input_file);
  GLCanvas glcanvas;

  glutInit(&argc,argv);
  glcanvas.initialize(args,mesh); 

  delete mesh;
  delete args;
  return 0;
}

// =========================================
// =========================================
