#ifndef _TRIANGLE_H
#define _TRIANGLE_H

#include "edge.h"

// ===========================================================

class Triangle {

public:

  // ========================
  // CONSTRUCTOR & DESTRUCTOR
  Triangle() {
    edge = NULL; 
    id = next_triangle_id;
    next_triangle_id++;
  }
  ~Triangle() {}

  // =========
  // ACCESSORS
  Vertex* operator[](int i) const { 
    assert (edge != NULL);
    if (i==0) return edge->getStartVertex();
    if (i==1) return edge->getNext()->getStartVertex();
    if (i==2) return edge->getNext()->getNext()->getStartVertex();
    assert(0);
  }
  Edge* getEdge() { 
    assert (edge != NULL);
    return edge; 
  }
  void setEdge(Edge *e) {
    assert (edge == NULL);
    edge = e;
  }
  int getID() { return id; }

  // NOTE: If you want to modify a triangle, it is recommended that
  // you remove it from the mesh, delete it, create a new copy with
  // the changes, and re-add it.  This will ensure the edges get
  // updated appropriately.

protected:

  // don't use these constructors
  Triangle& operator= (const Triangle &t) { assert(0); exit(0); }
  Triangle(const Triangle &t) { assert(0); exit(0); }
  
  // ==============
  // REPRESENTATION
  Edge *edge;
  int id;

  static int next_triangle_id;
};

// ===========================================================

#endif
