

pair<int, int> find_seed(graph& g1, graph& g2, 
  bool* aligned1, bool* aligned2, 
  float** costs)
{
  float min_cost = 2.1;
  int min1 = -1;
  int min2 = -1;
  for (int i = 0; i < g1.n; ++i) {
    if (!aligned1[i]) 
    {
      for (int j = 0; j < g2.n; ++j)
      {
        if (!aligned2[j])
        {
          float cost = costs[i][j];
          if (cost < min_cost)
          {
            min_cost = cost;
            min1 = i;
            min2 = j;
          }
        }
      }
    }
  }

  pair<int, int> seed;
  seed.first = min1;
  seed.second = min2;

  return seed;
}

int make_sphere(int* temp, int root, graph& g, int radius)
{
  bool* visited = new bool[g.n];
  for (int i = 0; i < g.n; ++i)
    visited[i] = false;
  visited[root] = true;

  int out_degree = out_degree(g, root);
  int* outs = out_vertices(g, root);
  copy(outs, outs + out_degree, temp);
  int temp_begin = 0;
  int temp_end = out_degree;

  for (int i = 1; i < radius; ++i)
  {
    int new_temp_end = temp_end;
    for (int j = temp_begin; j < temp_end; ++j)
    {
      out_degree = out_degree(g, temp[j]);
      outs = out_vertices(g, temp[j]);
      for (int k = 0; k < out_degree; ++k)
      {
        int out = outs[k];
        if (!visited[out])
        {
          visited[out] = true;
          temp[new_temp_end++] = out;
        }
      }
    }
    temp_begin = temp_end;
    temp_end = new_temp_end;
  }
  delete [] visited;

  return temp_end;
}

int make_sphere(int* temp, int root, graph& g, int radius, bool* invalid)
{
  bool* visited = new bool[g.n];
  for (int i = 0; i < g.n; ++i) 
    visited[i] = false;
  visited[root] = true;

  int temp_begin = 0;
  int temp_end = 0;
  int out_degree = out_degree(g, root);
  int* outs = out_vertices(g, root);
  for (int i = 0; i < out_degree; ++i)
  {
    int out = outs[i];
    if (!visited[out])
    {
      visited[out] = true;
      temp[temp_end++] = out;
    }
  }

  for (int i = 1; i < radius; ++i)
  {
    int new_temp_end = temp_end;
    for (int j = temp_begin; j < temp_end; ++j)
    {
      out_degree = out_degree(g, temp[j]);
      outs = out_vertices(g, temp[j]);
      for (int k = 0; k < out_degree; ++k)
      {
        int out = outs[k];
        if (!visited[out])
        {
          visited[out] = true;
          temp[new_temp_end++] = out;
        }
      }
    }
    temp_begin = temp_end;
    temp_end = new_temp_end;
  }
  delete [] visited;

  int new_size = 0;
  for (int i = temp_begin; i < temp_end; ++i)
    if (!invalid[temp[i]])
      temp[new_size++] = temp[i];

  return new_size;
}


int align_spheres(vector<pair<int, int> >& new_alignments,
  bool* aligned1, bool* aligned2,
  int* sphere1, int* sphere2, 
  int size1, int size2, 
  float** costs)
{
  int size = min(size1, size2);
  int new_num_alignments = 0;

  while (new_num_alignments < size)
  {
    vector<pair<int, int> > pairs;
    float min_cost = 2.1;
    for (int i = 0; i < size1; ++i) 
    {
      if (!aligned1[sphere1[i]])
      {
        for (int j = 0; j < size2; ++j)
        {
          if (!aligned2[sphere2[j]])
          {
            float cost = costs[sphere1[i]][sphere2[j]];
            if (cost <= min_cost)
            {
              if (cost < min_cost)
                pairs.clear();
              min_cost = cost;

              pair<int, int> new_pair;
              new_pair.first = sphere1[i];
              new_pair.second = sphere2[j];
              pairs.push_back(new_pair);
            }
          }
        }
      }
    }
    pair<int, int> new_alignment = pairs[rand() % pairs.size()];
    aligned1[new_alignment.first] = true;
    aligned2[new_alignment.second] = true;
    new_alignments.push_back(new_alignment);
    pairs.clear();
    ++new_num_alignments;
  }

  return new_num_alignments;
}


pair<int, int>* compute_alignment(graph* g1, graph* g2, float** costs)
{
  int num_verts1 = g1[0].n;
  int num_verts2 = g2[0].n;
  bool* aligned1 = new bool[num_verts1];
  bool* aligned2 = new bool[num_verts2];
  for (int i = 0; i < num_verts1; ++i) aligned1[i] = false;
  for (int i = 0; i < num_verts2; ++i) aligned2[i] = false;
  int* sphere1 = new int[num_verts1];
  int* sphere2 = new int[num_verts2];

  pair<int, int>* node_alignments = new pair<int, int>[num_verts1];
  int num_aligned = 0;

  int p = 0;
  while (num_aligned < num_verts1)
  {
    pair<int, int> seed = find_seed(g1[0], g2[0], aligned1, aligned2, costs);
    aligned1[seed.first] = true;
    aligned2[seed.second] = true;
    node_alignments[num_aligned++] = seed;

    int size = 1;
    int radius = 1;

    while (size > 0)
    {
      int size1 = make_sphere(sphere1, seed.first, g1[p], radius, aligned1);
      int size2 = make_sphere(sphere2, seed.second, g2[p], radius, aligned2);
      size = min(size1, size2);
      if (size > 0)
      {
        vector<pair<int, int> > new_alignments;
        int align_spheres_res = align_spheres(new_alignments,
          aligned1, aligned2,
          sphere1, sphere2, size1, size2, 
          costs);
        for (int i = 0; i < align_spheres_res; ++i)
          node_alignments[num_aligned++] = new_alignments[i];
      }
      ++radius;
    }
    if (radius >= 3 && p < 2)
      ++p;
  }

  return node_alignments;
}