
void calc_weights()
{
  weights_sum = 0.0;
  for (int i = 0; i < num_graphs; ++i)
  {
    weights[i] = 1 - log(weights[i])/log((double)num_graphs);
    weights_sum += weights[i];
  }
}

double get_similarity(long* counts1, long* counts2)
{
  double distance_sum = 0.0;
  for (int i = 0; i < num_graphs; ++i)
  {
    double cur_dist = weights[i];
    cur_dist *= fabs(log(counts1[i]+1.0)-log(counts2[i]+1.0));
    cur_dist /= log(max(counts1[i], counts2[i]) + 2.0);
    distance_sum += cur_dist;
  }

  double similarity = 1.0 - (distance_sum / weights_sum);
  assert(similarity <= 1.0);
  assert(similarity >= 0.0);
  return similarity;
}


#if RANDOM
void create_cost_matrix(graph& g1, graph& g2, 
  long** counts1, long** counts2, float** costs, double alpha)
{
  calc_weights();
  int max_deg1 = 0;
  int max_deg2 = 0;
  double max_deg_sum = 0.0;
  for (int i = 0; i < g1.n; ++i)
    if (max_deg1 < out_degree(g1, i))
      max_deg1 = out_degree(g1, i);
  for (int i = 0; i < g2.n; ++i)
    if (max_deg2 < out_degree(g2, i))
      max_deg2 = out_degree(g2, i);
  max_deg_sum = (double)max_deg1 + (double)max_deg2;

#pragma omp parallel for schedule(static)
  for (int i = 0; i < g1.n; ++i)
    for (int j = 0; j < g2.n; ++j)
    {
      double cur_cost = 0.0;
      cur_cost = (1.0 - alpha);
      cur_cost *= (out_degree(g1, i) + out_degree(g2, j));
      cur_cost /= max_deg_sum;
      cur_cost += alpha * ((double)rand() / RAND_MAX * 2.0);
      cur_cost = 2.0 - cur_cost;
      assert(cur_cost <= 2.0);
      assert(cur_cost >= 0.0);
      costs[i][j] = (float)cur_cost;
    }
}
#else
void create_cost_matrix(graph& g1, graph& g2, 
  long** counts1, long** counts2, float** costs, double alpha)
{
  calc_weights();
  int max_deg1 = 0;
  int max_deg2 = 0;
  double max_deg_sum = 0.0;
  for (int i = 0; i < g1.n; ++i)
    if (max_deg1 < out_degree(g1, i))
      max_deg1 = out_degree(g1, i);
  for (int i = 0; i < g2.n; ++i)
    if (max_deg2 < out_degree(g2, i))
      max_deg2 = out_degree(g2, i);
  max_deg_sum = (double)max_deg1 + (double)max_deg2;

#pragma omp parallel for schedule(static)
  for (int i = 0; i < g1.n; ++i)
    for (int j = 0; j < g2.n; ++j)
    {
      double cur_cost = 0.0;
      cur_cost = (1.0 - alpha);
      cur_cost *= (out_degree(g1, i) + out_degree(g2, j));
      cur_cost /= max_deg_sum;
      cur_cost += alpha * get_similarity(counts1[i], counts2[j]);
      cur_cost = 2.0 - cur_cost;
      assert(cur_cost <= 2.0);
      assert(cur_cost >= 0.0);
      costs[i][j] = (float)cur_cost;
    }
}
#endif

graph create_csr_power(graph g, int power)
{
  vector<int>* adj_lists = new vector<int>[g.n];
  int* temp = new int[g.n];
  unsigned new_m = 0;
  for (int i = 0; i < g.n; ++i)
  {
    int new_out_degree = make_sphere(temp, i, g, power);
    new_m += new_out_degree;
    for (int j = 0; j < new_out_degree; ++j)
      adj_lists[i].push_back(temp[j]);
  }
  assert((unsigned)pow(g.n, 2) >= new_m);

  int* new_out_array = new int[new_m];
  unsigned* new_out_degree_list = new unsigned[g.n+1];
  unsigned running_offset = 0;
  for (int i = 0; i < g.n; ++i)
  {
    int* outs = adj_lists[i].data();
    int num_outs = adj_lists[i].size();
    copy(outs, outs + num_outs, &new_out_array[running_offset]);
    new_out_degree_list[i] = running_offset;
    running_offset += num_outs;
  }
  new_out_degree_list[g.n] = running_offset;
  graph new_g = {g.n, new_m, new_out_array, new_out_degree_list};

  delete [] adj_lists;
  delete [] temp;


  return new_g;
}
