
bool edge_exists(graph& g, int v1, int v2)
{
  int out_degree = out_degree(g, v1);
  int* outs = out_vertices(g, v1);
  for (int i = 0; i < out_degree; ++i)
  {
    if (outs[i] == v2)
      return true;
  }

  return false;
}

double edge_correctness(graph& g1, graph& g2, pair<int, int>* alignment)
{
  int* mapping = new int[g1.n];
  for (int i = 0; i < g1.n; ++i)
    mapping[alignment[i].first] = alignment[i].second;

  int num_matched = 0;
#pragma omp parallel for reduction(+:num_matched) schedule(guided)
  for (int i = 0; i < g1.n; ++i)
  {
    int out_degree = out_degree(g1, i);
    int* outs = out_vertices(g1, i);
    for (int j = 0; j < out_degree; ++j)
    {
      int out = outs[j];
      if (edge_exists(g2, mapping[i], mapping[out]))
        ++num_matched;
    }
  }
  printf(" %d edges matched ", num_matched);

  return 2.0 * (double)num_matched / (double)g1.m;
}