// ================================================================
// Parse the command line arguments and the input file
// ================================================================

#include <iostream>
#include <fstream>

#include "mesh.h"
#include "argparser.h"
#include "meshdata.h"

#if __APPLE__
#include "matrix.h"
#else
#include <glm/gtc/type_ptr.hpp>
#endif


ArgParser *GLOBAL_args;

// The command line arguments
ArgParser::ArgParser(int argc, const char *argv[], MeshData *_mesh_data) {

  // set some default values
  mesh_data = _mesh_data;
  path = ".";
  mesh = NULL;
  
  // parse the command line arguments
  for (int i = 1; i < argc; i++) {
    if (std::string(argv[i]) == std::string("-input") || 
        std::string(argv[i]) == std::string("-i")) {
      i++; assert (i < argc); 
      separatePathAndFile(argv[i],path,input_file);
    } else if (argv[i] == std::string("-size")) {
      i++; assert (i < argc); 
      mesh_data->width = mesh_data->height = atoi(argv[i]);
    } else if (argv[i] == std::string("-wireframe")) {
      mesh_data->wireframe = 1;
    } else if (argv[i] == std::string("-gouraud")) {
      mesh_data->gouraud = true;
    } else if (argv[i] == std::string("-orthographic")) {
      mesh_data->perspective = false;
    } else if (argv[i] == std::string("-perspective")) {
      mesh_data->perspective = true;
    } else {
      std::cout << "ERROR: unknown command line argument " 
                << i << ": '" << argv[i] << "'" << std::endl;
      exit(1);
    }
  }


  mesh = new Mesh(this);
  mesh->Load(path+"/"+input_file);

  GLOBAL_args = this;
  
  mesh->packMesh(mesh_data);
}


void ArgParser::separatePathAndFile(const std::string &input, std::string &path, std::string &file) {
  // we need to separate the filename from the path
  // (we assume the vertex & fragment shaders are in the same directory)
  // first, locate the last '/' in the filename
  size_t last = std::string::npos;  
  while (1) {
    int next = input.find('/',last+1);
    if (next != (int)std::string::npos) { 
      last = next;
      continue;
    }
    next = input.find('\\',last+1);
    if (next != (int)std::string::npos) { 
      last = next;
      continue;
    }
    break;
  }
  if (last == std::string::npos) {
    // if there is no directory in the filename
    file = input;
    path = ".";
  } else {
    // separate filename & path
    file = input.substr(last+1,input.size()-last-1);
    path = input.substr(0,last);
  }
}

